// Enter your name and surname here
// Sleutel jou naame en van hier in
unit Question1_U;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Spin, pngimage, Math;

type
  TfrmQuestion1 = class(TForm)
    pnlHeader: TPanel;
    pnl1: TPanel;
    btnQ1_1: TButton;
    pnl3: TPanel;
    imgQ1_1: TImage;
    btnQ1_3: TButton;
    Label2: TLabel;
    pnl5: TPanel;
    cbxAccommodation: TCheckBox;
    btnQ1_5: TButton;
    pnlQ1_3: TPanel;
    lblName: TLabel;
    edtSurname: TEdit;
    pnlQ1_5: TPanel;
    pnl2: TPanel;
    btnQ1_2: TButton;
    lblQ1_2A: TLabel;
    lblQ1_2B: TLabel;
    sedNumNights: TSpinEdit;
    rgpChaletOption: TRadioGroup;
    pnl4: TPanel;
    btnQ1_4: TButton;
    Label1: TLabel;
    edtSightings: TEdit;
    redQ1_4: TRichEdit;
    procedure btnQ1_1Click(Sender: TObject);
    procedure btnQ1_2Click(Sender: TObject);
    procedure btnQ1_4Click(Sender: TObject);
    procedure btnQ1_3Click(Sender: TObject);
    procedure btnQ1_5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmQuestion1: TfrmQuestion1;

implementation

{$R *.dfm}

const
  dReserveLength = 40.4;
  dReserveWidth = 27.8;

procedure TfrmQuestion1.btnQ1_1Click(Sender: TObject);
begin
  // QUESTION 1.1
  pnlHeader.Caption := 'KOMANI GAME RESERVE';
  pnlHeader.Color := clBlack;
  pnlHeader.Font.Color := clWhite;
  imgQ1_1.Picture.LoadFromFile('elephant.png');
  btnQ1_1.Enabled := False;
end;

procedure TfrmQuestion1.btnQ1_2Click(Sender: TObject);
var
  dPerimeter, dSurfaceArea: Double;
begin
  // QUESTION 1.2
  dPerimeter := 2 * dReserveLength + 2 * dReserveWidth;
  lblQ1_2A.Caption := 'PERIMETER: ' + FloatToStr(dPerimeter) + ' km';
  dSurfaceArea := dReserveLength * dReserveWidth;
  lblQ1_2B.Caption := 'SURFACE AREA: ' + FloatToStr(dSurfaceArea)
    + ' square km';
end;

procedure TfrmQuestion1.btnQ1_3Click(Sender: TObject);
var
  iNumNights: Integer;
  dPrice, dTotal: Double;
begin
  // QUESTION 1.3
  if cbxAccommodation.Checked then
  begin
    iNumNights := sedNumNights.Value;
    if rgpChaletOption.ItemIndex = 0 then
    begin
      dPrice := 1050.00;
    end
    else
    begin
      dPrice := 1850.00;
    end;
    dTotal := iNumNights * dPrice;
    pnlQ1_3.Caption := 'Cost of accommodation: ' + FloatToStr(dTotal);
  end
  else
  begin
    pnlQ1_3.Caption := 'NO ACCOMMODATION';
  end;
end;

procedure TfrmQuestion1.btnQ1_4Click(Sender: TObject);
var
  sSightings: string;
  i, iCount: Integer;
begin
  // QUESTION 1.4
  redQ1_4.Clear();
  sSightings := edtSightings.Text;
  iCount := 0;
  for i := 1 to Length(sSightings) do
  begin
    if sSightings[i] = 'E' then
    begin
      redQ1_4.Lines.Add('Elephant');
    end
    else if sSightings[i] = 'B' then
    begin
      redQ1_4.Lines.Add('Buffalo');
    end
    else
    begin
      Inc(iCount);
      redQ1_4.Lines.Add('Lion');
    end;
  end;
  ShowMessage('Lion sightings: ' + IntToStr(iCount));
end;

procedure TfrmQuestion1.btnQ1_5Click(Sender: TObject);
var
  iRan: Integer;
  sSurname, sRefCode: string;
begin
  // QUESTION 1.5
  if edtSurname.Text = '' then
  begin
    ShowMessage('Please enter your surname.');
    edtSurname.SetFocus();
  end
  else
  begin
    sSurname := edtSurname.Text;
    Randomize();
    iRan := Random(9000) + 1000;
    sRefCode := '#' + IntToStr(iRan) + UpperCase(Copy(sSurname, 1, 2));
    pnlQ1_5.Caption := 'REF CODE: ' + sRefCode;
  end;
end;

end.
